#pragma once

#include "DllManager.h"
#include <afxsock.h>
#include "Thread.h"
////////////////////////////////////////////////////////////////////////////
class CServiceData;
////////////////////////////////////////////////////////////////////////////
class CDataLink : public CThread
{
protected:
	SOCKET			mSocket;
	Bool			mConnected;
	UInt8			mDataChannel;
	int				mCid;
	CDllManager*	mDllManager;
	Bool			mDataMode;
	CString			mNumber;
	Bool			mSuspend;

public:
	CDataLink(CDllManager* iDllManager, UInt8 iChannel, int iCid, CString iNumber);
	~CDataLink()	{ WSACleanup(); };
	virtual void	DoAction();
	virtual Bool	Connect(char *iHost, char *iPort, char *iProto);
	virtual Bool	Disconnect();
	virtual Bool	SendToServer(char* iBuffer, UInt16 iCount);
	virtual void	Pause();
	
	virtual Bool	IsDataMode()				{ return mDataMode; };
	virtual void	SetDataMode(Bool iDataMode)	{ mDataMode = iDataMode; };
	virtual int		GetRelatedCid()				{ return mCid; };
	virtual UInt8	GetRelatedChannel()			{ return mDataChannel; };
	virtual CString GetRelatedNumber()			{ return mNumber;};

};
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////